/*
 * COPYRIGHT (c) 2010 by Institute of Computer Science, 
 * Foundation for Research and Technology - Hellas
 * Contact: 
 *      POBox 1385, Heraklio Crete, GR-700 13 GREECE
 *      Tel:+30-2810-391632
 *      Fax: +30-2810-391638
 *      E-mail: isl@ics.forth.gr
 *      http://www.ics.forth.gr/isl/cci.html
 * 
 * This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 
 * Unported License (http://creativecommons.org/licenses/by-sa/3.0/)
*/

package Transformation;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.SAXException;

   
/**
 *
 * @author Koutraki Maria (kutraki@ics.forth.gr)
 */
public class LidoToCidocConvertion {

	 /**
     * Takes as input the mapping file in xml format and a lido xml file and produce a rdf file.
     * @param mappingFilePath the path of mapping file.
     * @param lidoFilePath the path of the lido xml file.
     * @param destinationFolderPath the path where will create the Result.rdf file.
     */

    public LidoToCidocConvertion(String mappingFilePath, String lidoFilePath, String destinationFolderPath) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException{
        parserOfMapping mappingPars = new parserOfMapping();
        mappingPars.parsing(new File(mappingFilePath));

        parserOfLidoFile lidoParser = new parserOfLidoFile(mappingPars, lidoFilePath);

        lidoParser.transform(mappingPars, lidoFilePath, destinationFolderPath);
    }

}
